/*
 * JStaticT.cpp
 *
 * Static text control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "jos2.h"
#include "JStaticT.hpp"
#include "JWindow.hpp"
#include "JCoord.hpp"
#include "JIntern.hpp"

const unsigned long JStaticText::left     = DT_LEFT;
const unsigned long JStaticText::center   = DT_CENTER;
const unsigned long JStaticText::right    = DT_RIGHT;
const unsigned long JStaticText::top      = DT_TOP;
const unsigned long JStaticText::vcenter  = DT_VCENTER;
const unsigned long JStaticText::bottom   = DT_BOTTOM;
const unsigned long JStaticText::wordWrap = DT_WORDBREAK;
const unsigned long JStaticText::normal   = DT_LEFT | DT_VCENTER | DT_WORDBREAK;

JStaticText::JStaticText( JWindow *parent, const JPoint &position,
                          const JSize &size, ulong ID,
                          ulong style, const char *text) : JControl()
{
   assertParms( parent, "JStaticText::JStaticText");
   JCreateWBlock b( parent->handle(), WC_STATIC, (char*)text,
                    JWindow::visible | SS_TEXT | style,
                    position, size, parent->handle(), HWND_TOP, ID, 0, 0);

   setHwnd( JInternal::window::create( &b));
}
