/*
 * JStrCli.cpp
 *
 * Class which contains common behaviour between files & client n-pipes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JStrCli.hpp"

JSharingViolation::JSharingViolation() : JException( err_sharing, JExn::sharing)
{}

JClientStream::JClientStream( const char *name, BOOL failIfNew,
                              BOOL appendIfOld,
                              BOOL isRead, BOOL isWrite,
                              JStream::sharing shr)
              : JStream( HBAD)
{
   open( name, failIfNew, appendIfOld, isRead, isWrite, shr);
}

void JClientStream::open( const char *name, BOOL failIfNew, BOOL appendIfOld,
                          BOOL isRead, BOOL isWrite, JStream::sharing shr)
{
   ulong rc, ulAction = 0;
   assertParms( name && ( isRead || isWrite), "JClientStream::JClientStream");

   ulong fsOpenFlags = 0;
   if( failIfNew) fsOpenFlags |= OPEN_ACTION_FAIL_IF_NEW;
   else           fsOpenFlags |= OPEN_ACTION_CREATE_IF_NEW;

   if( appendIfOld) fsOpenFlags |= OPEN_ACTION_OPEN_IF_EXISTS;
   else             fsOpenFlags |= OPEN_ACTION_REPLACE_IF_EXISTS;

   ulong fsOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | ( ulong) shr;
   if( isRead && isWrite)
      fsOpenMode |= OPEN_ACCESS_READWRITE;
   else if( isWrite)
      fsOpenMode |= OPEN_ACCESS_WRITEONLY;
   else
      fsOpenMode |= OPEN_ACCESS_READONLY;

   rc = DosOpen( name, &hStream, &ulAction, 0, 0, fsOpenFlags, fsOpenMode, 0);

   if( rc == ERROR_OPEN_FAILED && failIfNew)
      notFound( (char*)name);
   else if( rc == ERROR_SHARING_VIOLATION)
      jlib_throw( new JSharingViolation);
   else dosError( rc, "DosOpen");
}
