/*
 * JSwp.cpp
 *
 * SWP wrapper and 'array-of-swps' class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JWindow.hpp"
#include "JSwp.hpp"

// Swp class. A multiplicity of ctors -----------------------------------------
JSWP::JSWP( JWindow *insert) : fl( SWP_ZORDER), cy( 0), cx( 0), _y( 0), _x( 0),
                               behind( insert->handle()), hWnd( 0), d1( 0), d2( 0)
{}

JSWP::JSWP() : fl( 0), cy( 0), cx( 0), _y( 0), _x(0), behind( 0), hWnd( 0), d1( 0), d2( 0)
{}

JSWP::JSWP( ulong flags) : fl( flags), cy( 0), cx( 0), _y( 0), _x( 0), behind( 0), hWnd( 0), d1( 0), d2( 0)
{}

JSWP::JSWP( const JPoint &moveTo) : fl( SWP_MOVE), cy( 0), cx( 0), _y( moveTo.y), _x( moveTo.x),
                                    behind( 0), hWnd( 0), d1( 0), d2( 0)
{}

JSWP::JSWP( const JSize &sizeTo) : fl( SWP_SIZE), cy( sizeTo.y), cx( sizeTo.x), _y( 0), _x( 0),
                                   behind( 0), hWnd( 0), d1( 0), d2( 0)
{}

JSWP::JSWP( const JRect &shapeTo) : fl( SWP_MOVE | SWP_SIZE),
                                    cy( shapeTo.size().y), cx( shapeTo.size().x),
                                    _y( shapeTo.min.y), _x( shapeTo.min.x),
                                    behind( 0), hWnd( 0), d1( 0), d2( 0)
{}

JSWP::JSWP( const JPoint &moveTo, const JSize &sizeTo)
     :  fl( SWP_MOVE | SWP_SIZE), cy( sizeTo.y), cx( sizeTo.x),
       _y( moveTo.y), _x( moveTo.x), behind( 0), hWnd( 0) ,d1( 0), d2( 0)
{}

// Flags ----------------------------------------------------------------------
const ulong JSWP::activate   = SWP_ACTIVATE;
const ulong JSWP::deactivate = SWP_DEACTIVATE;
const ulong JSWP::hide       = SWP_HIDE;
const ulong JSWP::maximize   = SWP_MAXIMIZE;
const ulong JSWP::minimize   = SWP_MINIMIZE;
const ulong JSWP::move       = SWP_MOVE;
const ulong JSWP::restore    = SWP_RESTORE;
const ulong JSWP::show       = SWP_SHOW;
const ulong JSWP::resize     = SWP_SIZE;
const ulong JSWP::zorder     = SWP_ZORDER;

// PM Stuff -------------------------------------------------------------------
JSWP::operator _SWP * () const
{ return (PSWP) this; }

JSWP::operator _SWP & () const
{ return (SWP &) self; }

// SWPArray -------------------------------------------------------------------
JSWPArray::JSWPArray( JSWP *p, int count) : JSequence<JSWP*>()
{
   for( int i = 0; i < count; i++)
      append( p + i);               // umm... pointer arithmetic...
}

int JSWPArray::indexOf( ushort id)
{
   for( int i = 0; i < elements(); i++)
      if( WinQueryWindowUShort( (*elementAt( i))->hwnd(), QWS_ID) == id) return i;
   notFound( "swp");
   return 0;
}
