/*
 * JThread.cpp
 *
 * Implementation for thread class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "JOS2.h"
#include "JPM.hpp"
#include "JThread.hpp"
#include "JEvSem.hpp"
#include "JWindow.hpp"

#define JWM_THREADOVER WM_USER

// this is a thing that starts off a thread. Users don't see it.
class starter {
   JThread   *func;
   ulong      priority;
   ulong      delta;
   ulong      id;
   JEventSem &sem;

   JWindow    *client;

   // we need this really bizarre arrangement 'cos of stuff.
   friend void _Optlink _threadfn( void *arg)
   {
      JPM pm;

      JThread *fn;
      starter *me = (starter*) arg;
      fn = me->func;
      JWindow *client = me->client;
      ulong    id = me->id;

      me->sem.post();
      // 'me' data goes out of scope ... NOW.

      ulong rc = (*fn)();
      if( client)
         client->postEvent( JWM_THREADOVER, rc, id);
   }

 public:
   starter( JThread *f, ulong p, ulong d, JEventSem &s, JWindow *c, ulong i)
          : func( f), priority( p), delta( d), id( i), sem( s), client( c) {}
   TID run()
   {
      TID tid = _beginthread( _threadfn, NULL, 32768, this);
      long rc = DosSetPriority( PRTYS_THREAD, priority, delta, tid);
      dosError( rc, "DosSetPriority");
      return tid;
   }
};

const ulong JThread::overMsgID = JWM_THREADOVER;

void JThread::start( JWindow *c, ulong i, ulong p, ulong d)
{
   JEventSem started;
   starter h( this, p, d, started, c, i);
   tid = h.run();
   started.wait();
}

void JThread::wait()
{
   long rc = DosWaitThread( &tid, DCWW_WAIT);
   dosError( rc, "DosWaitThread");
}

void JThread::kill()
{
   long rc = DosKillThread( tid);
   dosError( rc, "DosKillThread");
}

void JThread::suspend()
{
   long rc = DosSuspendThread( tid);
   dosError( rc, "DosSuspendThread");
}

void JThread::resume()
{
   long rc = DosResumeThread( tid);
   dosError( rc, "DosResumeThread");
}

// (static)
void JThread::sleep( ulong ulMilliseconds)
{
   DosSleep( ulMilliseconds);
}

// Handler & event... drag. ---------------------------------------------------
BOOL JThreadHandler::handle( JEventData *e)
{
   BOOL rc = false;
   if( e->msg == JWM_THREADOVER)
      rc = threadOver( JThreadEvent( e));
   return rc;
}
