/*
 * JToolbar.cpp
 *
 * Toolbar -actually a bitmap menu
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JToolbar.hpp"
#include "JMenu.hpp"
#include "JWindow.hpp"
#include "JFrame.hpp"
#include "JSWP.hpp"
#include "JResID.hpp"

const ulong JToolbar::idToolbar = 0x8001; // FID_TOOLBAR

JToolbar::JToolbar( JFrame *frame, const JResID &resID)
         : JFrameCtl( JToolbar::idToolbar), szLast( 0)
{
   ctl = new JMenu( resID, frame);
   ctl->setID( JToolbar::idToolbar);
}

JMenu *JToolbar::window() const
{
   return (JMenu *) ctl;
}

// the menu control knows how to arrange itself to become >1 layered, so
// do some special bits here
void JToolbar::format( JSWPArray &swps, JSWP &mySwp, JFrame *)
{
   short client = swps.indexOf( JFrame::idClient);
   JSWP *swpCli = *(swps[ client]);

   // set size to max, and then get the menu ctl to resize it
   mySwp.width() = swpCli->width();
   mySwp.height() = swpCli->height();
   ctl->sendEvent( WM_ADJUSTWINDOWPOS, &mySwp);
   szLast = mySwp.height();

   // position control
   mySwp.x() = swpCli->x();
   mySwp.y() = swpCli->y() + swpCli->height() - mySwp.height();
}

void JToolbar::adjustClientRect( JRect *rcl) const
{
   rcl->max.y -= szLast; // !! dodgy-ish on first call...
}
