/*
 * JTrace.cpp
 *
 * Trace class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "Jos2.h"
#include "JPM.hpp"
#include "JTrace.hpp"
#include "JNPipes.hpp"
#include "JStr.hpp"
#include "JExcept.hpp"
#include <string.h>

#pragma priority( -1001)

JTrace::JTrace() : JMutexSem( "JLTRACE")
{ }

JTrace &JTrace::operator << ( const char *s)
{
   BOOL    b = JException::debugEnabled;
   JBuffer buff( 1024);

#ifdef REALLY_THROW_EXCEPTIONS
   try {
#endif
      // prevent crazy spinning
      JException::debugEnabled = 0;

      lock lok( self);

      JWNamedPipe pipe( "JLDEBUG", 1);
#ifndef REALLY_THROW_EXCEPTIONS
      if( !JPM::current()->exn) {
#endif
      strcpy( (char *) buff.pvAddr(), s);

      pipe.write( buff);
#ifdef REALLY_THROW_EXCEPTIONS
   } catch( JException *e) {
   }
#else
   }
   jlib_catch();
#endif

   JException::debugEnabled = b;
   return self;
}

JTrace trace;
