/*
 * JWCursor.cpp
 *
 * Window child cursor subclass of JWindow
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JWindow.hpp"

JWindow::cursor::cursor( JWindow *w) : hEnum( 0), wnd( w), curr( 0) {}

JWindow::cursor::~cursor()
{
   check();
}

void JWindow::cursor::check( void)
{
   if( hEnum) { WinEndEnumWindows( hEnum); hEnum = 0; }
   if( curr) { curr = 0; }
}

JWindow::cursor &JWindow::cursor::toFirst()
{
   check();
   hEnum = WinBeginEnumWindows( wnd->handle());
   if( !hEnum)
      pmError( 1, "WinBeginEnumWindows");
   return toNext();
}

JWindow::cursor &JWindow::cursor::toNext()
{
   if( hEnum) {
      HWND h = WinGetNextWindow( hEnum);
      if( h) {
         curr = JWindowPtr( h);
      }
      else curr = 0;   // end of list reached
   }
   return self;
}

BOOL JWindow::cursor::isValid() const
{
   return hEnum && curr;
}

JWindow *JWindow::cursor::current()
{
   JWindow *rc = 0;

   if( !isValid())
      badcursor;
   else
      rc = curr;

   return rc;
}
