/*
 * JWrap.cpp
 *
 * A word-wrapped static text control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#define _jlib_err
#include "Jos2.h"
#include "JWrap.hpp"
#include "JPaintH.hpp"
#include "JColour.hpp"
#include "JIntern.hpp"
#include "JPSpace.hpp"

// Paint handler -------------------------------------------------------------
class JWrapPaintHandler : public JPaintHandler
{
 public:
   JWrapPaintHandler() : JPaintHandler() {}
   BOOL paint( JPaintEvent &e)
   {
      JWrapText *win = (JWrapText *) e.window();
      JRect      rclWin( 0, 0, win->size() );

      e.ps().fillRect( e.updateRect(), JColour::dialogBackground);

      rclWin.max.y -= (rclWin.max.y - win->ht) / 2;

      win->wrap( e.ps(), rclWin, true);
      return true;
   }
};

static JWrapPaintHandler wrappainthandler;

// Style ---------------------------------------------------------------------
const ulong JWrapText::normal      = 0x2;
const ulong JWrapText::centred     = 0x1;
const ulong JWrapText::leftAligned = 0x2;

// Constructors, helper method, rest of class --------------------------------
JWrapText::JWrapText( JWindow *parent, const JPoint &pos, const JSize &size,
                      ulong Id, ulong style) : JControl()
{
   setup( parent, pos, size, Id, style);
}

JWrapText::JWrapText( JWindow *parent, ulong Id, ulong style) : JControl()
{
   // find out about the guy we're gonna replace
   JWindow *ctrl = parent->childWithID( Id);
   JSize sz = ctrl->size();
   JPoint wh = ctrl->origin();
   // then grease him
   ctrl->destroy();
   // and replace with us
   setup( parent, wh, sz, Id, style);
}

void JWrapText::setup( JWindow *w, const JPoint &p, const JSize &z, ulong i,
                       ulong s)
{
   assertParms( w, "JWrapText::ct");

   JCreateWBlock b( w->handle(), JInternal::window::name(), 0, JWindow::visible | s,
                    p, z, w->handle(), HWND_TOP, i, 0, 0);

   setHwnd( JInternal::window::create( &b));

   text = " ";
   // attach paint handler
   attach( &wrappainthandler);
   ht = 16; //!!
}

// text access methods
JWrapText &JWrapText::setText( const char *txt)
{
   text = txt;
   ht = height();
   invalidate();
   return self;
}

// get the height necessary
ulong JWrapText::height( ulong xSpace)
{
   JRect rcl( 0, 0, size().x, 5000);

   if( xSpace) rcl.max.x = xSpace;

   JWindowPS ps( this);
   ulong height = wrap( ps, rcl, false);

   return height;
}

// wrap method; dual purpose: calculates height, may draw text too
ulong JWrapText::wrap( JBPSpace &ps, const JRect &rcl, BOOL doit)
{
   FONTMETRICS fm;
   long  lTextHeight;
   long  lTextLength = text.length();
   long  lTotalDrawn = 0;
   long  lTotalHeight = 0;
   long  lDrawn;
   ulong flags = DT_WORDBREAK | DT_TOP | DT_TEXTATTRS;
   JRect rclTemp;

   if( hasStyle( JWrapText::centred))
      flags |= DT_CENTER;
   else flags |= DT_LEFT;

   GpiQueryFontMetrics( ps, sizeof( FONTMETRICS), &fm);
   lTextHeight = fm.lMaxAscender + fm.lMaxDescender;

   if (!doit)
      flags |= DT_QUERYEXTENT;

   rclTemp.max = rcl.max;

   while( lTotalDrawn < lTextLength) {
      // do this here 'cos WinDrawText updates it to be the
      // actual width used.
      rclTemp.max.x = rcl.max.x;
      rclTemp.min.y = rclTemp.max.y - lTextHeight;
      lDrawn = WinDrawText( ps,
                            lTextLength - lTotalDrawn,
                            text.buffer() + lTotalDrawn,
                            rclTemp,
                            0, 0,
                            flags);
      if( !lDrawn) break;
      lTotalDrawn += lDrawn;
      lTotalHeight += lTextHeight;
      rclTemp.max.y -= lTextHeight;
   }
   return lTotalHeight;
}
