/*
 * JIntern.hpp
 *
 * Internal functions, used from various places
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jintern_h
#define _jintern_h

#include "JLib.h"

#include "JCoord.hpp"

struct JCreateWBlock
{
   ulong  parent;
   char  *clss;
   char  *name;
   ulong  style;
   JPoint pos;
   JSize  size;
   ulong  owner;
   ulong  behind;
   ulong  ID;
   void  *ctldata;
   void  *pparams;
   JCreateWBlock( ulong p, char *c, char *n, ulong s, const JPoint &pt,
                  const JSize &sz, ulong o, ulong b,
                  ulong id, void *v1, void *v2);
};

struct JCreateDlg
{
   ulong hwndO;
   ulong hwndP;
   ulong hMod;
   ushort id;
   JCreateDlg( ulong o, ulong p, ulong m, ushort i)
      : hwndO( o), hwndP( p), hMod( m), id( i) {}
};

struct JInternal
{
   struct window
   {
      static char *name();
      static char *SRName();
      static ulong create( JCreateWBlock *b);
      static ulong create( const JCreateWBlock &b);
      static void destroy( ulong hwnd);
   };

   struct dialog
   {
      static ulong process( ulong hwnd);
      static ulong createDlg( const JCreateDlg &cd);
      static ulong createDlg( JCreateDlg *cd);
   };
};

#endif
