/*
 * JLibErr.h
 *
 * Error codes for message file; internal
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jliberr_h
#define _jliberr_h

// Error code definitions

#define err_params                      1
#define err_badcursor                   2
#define err_bounds                      3
#define err_duplicate_key               4
#define err_notfound                    5
#define err_dosapi                      6
#define err_nostream                    7
#define err_eof                         8
#define err_brokenpipe                  9
#define err_pmbase                      9
#define err_pm1                        10
#define err_pm2                        11
#define err_pm3                        12
#define err_pm4                        13
#define err_resource                   14
#define err_nopm                       15
#define err_msgpost                    16
#define err_badea                      17
#define err_badwrite                   18
#define err_sharing                    19
#define err_accel                      20
#define err_lbox1                      21
#define err_lbox2                      22
#define err_lboxitem                   23
#define err_ef                         24
#define err_efbounds                   25
#define err_menu                       26
#define err_static                     27
#define err_button                     28
#define err_mle                        29
#define err_mletoobig                  30
#define err_scrollbar                  31
#define err_scanvas                    32
#define err_spin                       33
#define err_cnr                        34
#define err_cnrnotnew                  35
#define err_nocnrobjcontext            36
#define err_drag                       37
#define err_doubledrag                 38
#define err_nodrag                     39
#define err_notebook                   40
#define err_duplicate_el               41
#define err_nullptr                    42
#define err_win_duplicate              43
#define err_wact_forbidden             44
#define err_valueset                   45
#define err_msgloadfailed              46

// macros; assert-ing that c is true. s is function name
#define assertParms( c, s) if( !(c)) jlib_throw( new JException( err_params, JExn::params, s))
#define pmError( c, s) jlib_throw( new JPMExcep( err_pmbase + c, s))
#define resError( s) jlib_throw( new JException( err_resource, JExn::resource, s))
#define notFound( s) jlib_throw( new JNotFoundError( err_notfound, s))
#define dosError( rc, s) if( rc) jlib_throw( new JDosExcep( rc, err_dosapi, s))
#define badcursor jlib_throw( new JException( err_badcursor, JExn::base))

#endif
