/*
 * JAccel.hpp
 *
 * Accelerator classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jaccel_h
#define _jaccel_h

// potential for a grest deal here, but would involve trawling through headers
// for hundreds of VK_ defines; not going to implement this yet - I ask you,
// who's going to mess with ACCELTABLEs manually anyway :-)

#include "JLib.h"
#include "JModule.hpp"
#include "JKeyH.hpp"

class JResID;

// Accelerator table entry ----------
class JAccel
{
   ushort fs;
   ushort key;
   ushort cmd;

 public:

   enum options {
      alt        = 0x020,
      shift      = 0x008,
      control    = 0x010
   };

   JAccel();
   JAccel( void *pAccel);
   JAccel( options opts, ushort key, ushort value);
   JAccel( options opts, JKeyEvent::vkeys key, ushort value);
};

// Accelerator table ----------
class JAccelTable
{
   ulong  hAccel;
   void  *pTable;
   BOOL   autodelete;
   void   get();

 public:
   JAccelTable( const JResID &resId, const JModule &mod = JModule::theResMod);
   JAccelTable();
   JAccelTable( const JAccelTable &copy);

  ~JAccelTable();

   operator ulong () const { return handle(); }
   ulong handle() const    { return hAccel; }

   JAccelTable &addAccel( const JAccel &entry);
   ushort       query( ushort key, JAccel::options options);
};

#endif
