/*
 * JAtoms.hpp
 *
 * Atom tabels, atoms, custom messages
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jatoms_h
#define _jatoms_h

#include "JLib.h"

class JStr;

class JAtom
{
   ulong hAtom;

 public:
   JAtom( ulong h) : hAtom( h) {}
   ulong handle() const { return hAtom; }
};

class JAtomTable
{
   ulong hTable;

 public:
   JAtomTable( ulong wrapMe);
   JAtomTable();
  ~JAtomTable();

   JAtom add( const char *s) const;
   JAtomTable &remove( const JAtom &atom);

   JStr nameOf( const JAtom &atom) const;

   ulong usageCountOf( const JAtom &atom) const;

   static JAtomTable system;
};

// use this to generate a unique message ID; fairly useful in the case where
// you're defining mix-in classes which need their own messages.  You can't
// just use WM_USER 'cos there's no way of knowing who else might be.
class JMsgID
{
   JAtom atom;

 public:
   JMsgID( const char *name);
  ~JMsgID();

   operator ulong () const { return atom.handle(); }
   ulong handle() const { return atom.handle(); }
};

#endif
