/*
 * JBFile.hpp
 *
 * Base disk file classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jbfile_h
#define _jbfile_h

#include "JLib.h"
#include "JStrCli.hpp"
#include "JStr.hpp"
#include "JIcon.hpp"
#include "JDtTime.hpp"
#include "JExcept.hpp"
#include "JResId.hpp"
#include "JModule.hpp"

// this is the class which includes file-like behaviour ----------------------
class JFile : public JClientStream
{
   JStr name;

 protected:
   JFile( const char *name, BOOL failIfNew, BOOL append, BOOL isRead,
          BOOL isWrite, JStream::sharing = JStream::denyNone);
 public:
   virtual ~JFile() {}

   // file pointer manipulation (seek) functions
   enum seekType {
      start,
      current,
      end
   };
   JFile &seek( seekType how, long count = 0);
   // get current position
   ulong  tell() const;

   // get size of file in bytes
   ulong  size() const;
   // set size
   JFile &setSize( ulong);
   // get size of a file
   static ulong sizeOf( const char *filename);

   // get full path of a file
   JStr path() const;
   static JStr pathOf( const char *leafname);

   // delete functions
   void erase( BOOL force = true);
   static void erase( const char *file);

   // does a file exist?
   static BOOL exists( const char *file);

   // setting and getting string extended attributes
   // !! this is broken
   JFile &setEA( const char *ea_type, const char *value);
   JStr   EAValue( const char *ea_type) const;

   // special-case
   JFile &setType( const char *type);
   JStr   fileType() const;

   // icon-getting & setting functions
   static JIcon getIcon( const char *fname, BOOL privateCopy = false);
   static void setIcon( const char *fname, const JResID &id,
                        const JModule &m = JModule::theResMod);
   // attributes
   enum attribute {
      normal    = 0x00,
      readOnly  = 0x01,
      hidden    = 0x02,
      system    = 0x04,
      directory = 0x10,
      archived  = 0x20
   };
   ulong  attributes() const;
   BOOL   hasAttribute( JFile::attribute) const;

   JFile &setAttributes( ulong attrs);
   JFile &giveAttribute( JFile::attribute);
   JFile &takeAttribute( JFile::attribute);

   static BOOL hasAttribute( const char *file, JFile::attribute);

   // date & time
   JDateTime whenCreated() const;
   JDateTime whenLastAccessed() const;
   JDateTime whenLastWritten() const;
};

// thrown when an ea read is not of type string
struct JEANotString : public JException
{
   JEANotString();
};

#endif
