/*
 * JBNPipe.hpp
 *
 * Base named-pipe stream classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jbasenp_h
#define _jbasenp_h

#include "JLib.h"
#include "JStream.hpp"
#include "JStrCli.hpp"
#include "JEvSem.hpp"
#include "JBuffer.hpp"

// Really need the CP ref to be able to use these (or look at JTrace & JDebug
// for an example of pipe servers & connections and things)

class JNamedPipe : public virtual JStream
{
 protected:
   JNamedPipe() : JStream() {}

 public:
   // attribute querying: set/get blocking mode
   BOOL        isBlocking() const;
   JNamedPipe &setBlock( BOOL set = true);
   // is byte or message pipe
   BOOL        isMsgPipe() const;
   // set/get read mode (byte/message)
   BOOL        isMsgRead() const;
   JNamedPipe &setMsgRead( BOOL set = true);

   // get pipe state
   enum pstate {
      disconnected = 1,
      listening,
      connected,
      closing
   };
   pstate state() const;

   // peek into pipe, takes a JVBuffer. Returns bytes read.
   ulong peek( JVBuffer &fillMe) const;

   // add an event semaphore to the pipe
   void addSemaphore( const JEventSem &s, ulong id = 0) const;

   // wrapper to transactnpipe, taking 2 jvbuffers.  Returns bytes read.
   ulong transact( const JVBuffer &write_me, JVBuffer &read_to_me) const;

   // static function wrapping callnpipe
   static ulong call( const char *name, const JVBuffer &input,
                      JVBuffer &output, ulong wait = 5000,
                      const char *servername = 0);
};

class JPipeServer : public JNamedPipe
{
 protected:
   // the pipe server object creates a named pipe which is then closed
   // when the object gets dtor'ed. Use the connection sub-object to
   // connect to and manage clients.
   JPipeServer( const char *name, BOOL isRead, BOOL isWrite, BOOL isBytePipe,
                uchar count, BOOL block, BOOL openAsByte,
                ulong inBuffer, ulong outBuffer, ulong wait);
 public:
   virtual ~JPipeServer() {}

   class connection
   {
      JPipeServer &srv;

    public:
      // note this will throw a dosError if the pipe is non-blocking and
      // the client's not open'ed the other end.
      connection( JPipeServer &pipe);
     ~connection();
   };
};

// bit of a 'nothing' class, but does provide the ability to wait for a
// connection
class JPipeClient : public JNamedPipe, public JClientStream
{
 protected:
   // connects to pipe with name. If busy, will wait for connection,
   // default of -1 means wait for time specified by server during pipe
   // creation. Specifying server will make the pipe connect across the lan
   // to the lan server which is given.
   JPipeClient( const char *name, const char *srv,
                ulong timeToWait, BOOL isR, BOOL isW);
 public:
   virtual ~JPipeClient() {}
};

#endif
