/*
 * JBitmap.hpp
 *
 * Bitmaps
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jbitmap_h
#define _jbitmap_h

#include "JLib.h"
#include "JSeq.hpp"
#include "JCoord.hpp"
#include "JModule.hpp"

#define NO_PRIMS
#include "JGPrim.hpp"
#undef NO_PRIMS

class JResID;
class JColour;
class JBPSpace;

class JBitmapData;

class JBitmap : public JGObject
{
   friend class JBitmapData;
   JBitmapData *data;


 public:
   JBitmap( ulong hBitmap);
   // this doesn't do what you might think.  It doesn't create a new bitmap,
   // but transfers ownership of the handle.  The right thing when returning
   // JBitmap objects by value, the wrong thing if you actually want to create
   // a new bitmap.  To do the latter, create a new bitmap with the (size,bpp)
   // constructor & draw into it using a dc & ps.
   JBitmap( const JBitmap &copy);
   JBitmap( const JSize &pels, ulong bpp = 24);
   JBitmap( const JResID &id, const JModule &m = JModule::theResMod,
            const JSize &size = JSize());

  ~JBitmap();

   // access to things
   ulong handle() const;
   JSize size() const;
   ulong bpp() const;

   // save in .bmp format (!! want to make this better, add compound support)
   JBitmap &saveAs( const char *filename);

   // transparency
   JColour  transparentColour() const;
   BOOL     hasTransparency() const;
   JBitmap &setTransparentColour( const JColour &col);

   // render in a PS - uses transparency if set and transforms etc.
   BOOL renderIn( JBPSpace &ps) const;
};

// .BMP, .PTR & .ICO files contain bitmaps.  This thing can parse them
// and create a collection of bitmaps. Errors while reading are signalled,
// but an empty collection is a sure sign.
class JBitmapReader : public JSequence<JBitmap*>
{
 public:
   JBitmapReader( const char *filename) { read( filename); }

   JBitmapReader &read( const char *filename);
};

#endif
