/*
 * JBorder.hpp
 *
 * A border control, based on static things
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jborder_h
#define _jborder_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"

class JWindow;
class JBPSpace;

// A static control, but has a couple of extra styles settable at runtime
// to bevel in or out in a 3-d stylee
class JBorder : public JControl
{
 public:

   enum type {
      normal   = 0,
      bevelOut = 0x400,      // undocumented PM styles... gosh.
      bevelIn  = 0x800
   };

   JBorder( JWindow *parent, ulong id);
   JBorder( ulong hwnd);
   JBorder( JWindow *parent, const JPoint &position,
            const JSize &size, ulong id);
   virtual ~JBorder() {}

   virtual BOOL event( const JCtlEvent &) { return false; }
   JBorder &setType( type);
   JBorder &setSize( const JSize &s);
 private:

   friend class JBorderPaintHandler;
   type  drawtype;
   JSize sizee;
   void  paint( JBPSpace &ps, JRect &updateRect);
};

#endif
