/*
 * JBuffer.hpp
 *
 * Interface class for representing anonymous-ish blocks of memory
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jbuffer_h
#define _jbuffer_h

#include "JLib.h"
#include <stdlib.h>
#include <string.h>

struct JVBuffer
{
   virtual ulong cbSize() const = 0;
   virtual void *pvAddr() const = 0;
   virtual ~JVBuffer() {}
};

// not sure what this was meant for; looks potentially useful, so let's keep
// it around for the present...
template <class T>
class JTBuffer : public JVBuffer
{
   ulong  size;
   uchar *buffer;

 public:
   JTBuffer( ulong c = 0) : size( c) { buffer = (uchar *) malloc( size);}
   JTBuffer( const JBuffer &copy) : size( copy.cbSize()),
                                    buffer( (uchar *) malloc( copy.cbSize()))
   { memcpy( buffer, copy.pvAddr(), size); }
  ~JTBuffer() { if( buffer) free( buffer); }

   JTBuffer<T> &setSize( ulong n)
   { buffer = (uchar *) realloc( buffer, n); return *this; }

   T &operator[] ( int i) { return ((T *) buffer)[ i]; }

   ulong cbSize() const   { return size; }
   void *pvAddr() const   { return (void *) buffer; }
   operator T *() const   { return (T*) buffer; }
   T *operator() () const { return (T*) buffer; }
};

class JBuffer : public JVBuffer
{
   uchar *buffer;
   ulong  size;

 public:
   JBuffer( ulong c = 0);
   JBuffer( const JBuffer &copy);
  ~JBuffer()         { delete [] buffer; }

   JBuffer &setSize( ulong n);

   ulong cbSize() const       { return size; }
   void *pvAddr() const       { return buffer; }
   operator void *() const    { return buffer; }
   void *operator() () const  { return buffer; }
};

// potential for making this more like JStr...
// inlines for JBuffer
inline JBuffer::JBuffer( ulong v) : buffer( new uchar[ v]), size( v)
{ 
   memset( buffer, 0, size);
}

inline JBuffer::JBuffer( const JBuffer &copy)
{
   size = copy.cbSize();
   buffer = new uchar [ size ];
   memcpy( buffer, copy.pvAddr(), size);
}

inline JBuffer &JBuffer::setSize( ulong n)
{
   delete [] buffer;
   buffer = new uchar [ n];
   size = n;
   return *this;
}

#endif
