/*
 * JButton.hpp
 *
 * Base button control - sorta a.b.c, but not really.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jbutton_h
#define _jbutton_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"

class JWindow;
class JCtlEvent;

class JButton : public JControl
{
 protected:
   JButton( JWindow *parent, const char *text, ulong style,
            const JPoint &pos, const JSize &size, ulong id);

 public:
   JButton( ulong hwnd) : JControl( hwnd) {}
   JButton( JWindow *parent, ulong id) : JControl( parent, id) {}

   // style
   static const unsigned long
      autosize;

   // simulate a mouseclick on the button
   JButton &click();

   // events
   virtual BOOL event( const JCtlEvent &e);
   virtual BOOL mouseclick()   { return false; }
   virtual BOOL doubleclick()  { return false; }
};

#endif
