/*
 * JCBox.hpp
 *
 * Combobox control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcbox_h
#define _jcbox_h

#include "JLib.h"
#include "JListbox.hpp"
#include "JCoord.hpp"

class JWindow;
class JEntryField;
class JCtlEvent;

// this is somewhat hacky; inherit from listbox to obtain access to the
// messaging available there: see the implementation for details...
class JComboBox : public JListBox
{
   JEntryField *ef;
   JListBox    *lb;
   void getChilder();

 public:
   // style
   static const unsigned long
      simple,
      dropdown,
      dropdownRO,
      normal,
      autotab,
      horzScroll;

   // constructors...
   JComboBox( ulong hwnd);
   JComboBox( JWindow *mother, ulong id);
   JComboBox( JWindow *mother, const JPoint &pos, const JSize &size, ulong id,
              ulong style = JComboBox::normal);
  ~JComboBox();

   // access to components
   JListBox    &listbox()      { return *lb; }
   JEntryField &entryfield()   { return *ef; }

   // direct interaction
   BOOL       isListShowing() const;
   JComboBox &showList( BOOL show = true);
   JComboBox &hilight( BOOL yes = true);

   // event handling
   BOOL event( const JCtlEvent &e);
   virtual BOOL changed()                       { return false; }
   virtual BOOL efScrolled()                    { return false; }
   virtual BOOL lbScrolled()                    { return false; }
   virtual BOOL selected( JListBox::cursor &)   { return false; }
   virtual BOOL dropDown()                      { return false; }
   virtual BOOL choice( JListBox::cursor &)     { return false; }
};

#endif
