/*
 * JCanvas.hpp
 *
 * Base drawing canvas
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcanv_h
#define _jcanv_h

#include "JLib.h"
#include "JControl.hpp"
#include "JPaintH.hpp"
#include "JCoord.hpp"

class JCtlEvent;
class JMemoryDC;
class JWindow;
class JBitmap;
class JPSpace;

class JCanvas : public JControl, public JPaintHandler
{
 public:
   JCanvas( JWindow *parent, const JPoint &pos = JPoint(),
            const JSize &size = JPoint(), ulong id = 0,
            ulong style = JWindow::normal);

   static const ulong
      sizeRedraw;

   // this will create a canvas where the indictated control was, after
   // deleteing it - use a static text, or something.
   JCanvas( JWindow *parent, ulong id);

   // think this:
   // virtual BOOL paint( JPaintEvent &e) = 0;

   BOOL event( const JCtlEvent &) { return false; }
};

// This class of gui component provides a buffered drawing canvas.
// When you create one, the bitmap parameters determine what can be
// displayed.  ps() is valid for drawing onto; call invalidate(...) to force
// a copy-up to screen.
class JBufferedCanvas : public JCanvas
{
   JMemoryDC *_dc;
   JPSpace   *_ps;
   JBitmap   *_bmp;

   BOOL paint( JPaintEvent &e);

   void setup( const JSize &pelSz, ulong bpp);

 public:
   JBufferedCanvas( const JSize &pelSize, ulong bpp, // bitmap parameters
                    JWindow *parent, const JPoint &pos = JPoint(),
                    const JSize &size = JSize(), ulong id = 0,
                    ulong style = JWindow::normal);
   JBufferedCanvas( const JSize &pelSize, ulong bpp, JWindow *parent, ulong id);
   virtual ~JBufferedCanvas();

   JBitmap   *bitmap() const { return _bmp; }
   JMemoryDC *dc() const     { return _dc; }
   JPSpace   *ps() const     { return _ps; }

   // reset the bitmap associated with the canvas; this could be a lot
   // smarter, ie. copying current contents over.
   void setNewBitmapSize( const JSize &pelSize);
};

#endif
