/*
 * JCmdH.hpp
 *
 * Command event and handler class definitions
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcmdevent_h
#define _jcmdevent_h

#include "JLib.h"
#include "JEvent.hpp"
#include "JHandler.hpp"

class JCmdEvent : public JEvent
{
 public:
   JCmdEvent( JEventData *e) : JEvent( e) {}

   enum source {
      other,
      button,
      menu,
      accel,
      fontDlg,
      fileDlg,
      printDlg,
      colourDlg
   };

   enum device {
      keyboard,
      mouse
   };

   ushort value() const    { return e->mp1.s1(); }
   source src() const      { return (source) e->mp2.s1(); }
   device pointer() const  { return (device) e->mp2.s2(); }
};                           

// Handler; attach to mothers with system menus, button children, etc.
class JCmdHandler : public JHandler
{
   short id;

 public:
   JCmdHandler( short Id = -1) : id( Id) {}
   BOOL handle( JEventData *e);

   virtual BOOL command( const JCmdEvent &)       { return false; }
   virtual BOOL syscommand( const JCmdEvent &)    { return false; }
};

#endif
