/*
 * JCnr2.hpp
 *
 * Enumerations used in container-land
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcnr2_h
#define _jcnr2_h

#include "JLib.h"
#include "JCoord.hpp"

class JCnr
{
 public:
   // selection type
   enum selType {
      single   = 4,
      multiple = 2,
      extended = 1
   };

   // view type
   enum view_type {
      icon           = 4,
      miniIcon       = 4 | 32,
      name           = 2,
      miniName       = 2 | 32,
      flowedMiniName = 2 | 32 | 16,
      flowedName     = 2 | 16,
      text           = 1,
      flowedText     = 1 | 16,
      treeIcon       = 64 | 4,
      tree           = 64 | 4,
      treeName       = 64 | 2,
      treeText       = 64 | 1,
      details        = 8,
      miniDetails    = 8 | 32,
      detailsTitles  = 0x8008,
      miniDetailsTitles = 0x8028
   };

   // title alignment
   enum title_align {
      title_left   = 0x0800,
      title_right  = 0x1000,
      title_centre = 0x2000
   };

   // scroll the container
   enum scroll_dir {
      horizontal = 0x200,
      vertical = 0x400
   };

   // inserting some records
   enum rec_insert {
      first = 0x10,
      last  = 0x40
   };

   // record emphasis
   enum emphasis {
      selected = 0x0001,
      cursored = 0x0004,
      open     = 0x0008,
      filtered = 0x0010,
      picked   = 0x0200,
      sourced  = 0x4000
   };

   // column data type
   enum column_type {
      string  = 0x00800,
      integer = 0x20000,
      date    = 0x02000,
      time    = 0x04000,
      graphic = 0x00100,
      custom  = 0x01000
   };

   // delta notify code
   enum deltaType {
      topRec    = 0x1,
      bottomRec = 0x2,
      atStart   = 0x4,
      atEnd     = 0x8
   };
};

class JCnrColumn;

struct JFieldInfo
{
   ulong       length;
   ulong       flField;
   ulong       flTitle;
   char       *title;
   ulong       offset;
   JCnrColumn *me;
   JFieldInfo *next;
   ulong       width;
};

struct JMiniRCore
{
   ulong       size;
   ulong       attributes;
   JPoint      position;
   JMiniRCore *next;
   char       *txtIcon;
   ulong       hIcon;
};

#endif
