/*
 * JCnrCol.hpp
 *
 * Container column
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcnrcol_h
#define _jcnrcol_h

#include "JLib.h"
#include "JCnr2.hpp"
#include "JStr.hpp"
#include "JSeq.hpp"

class JFieldInfo;
class JContainer;

class JCnrColumn
{
   JFieldInfo *data;
   JContainer *cnr;
   friend class JContainer;

 protected:
  ~JCnrColumn();

 public:
   // style
   static const ulong
      readOnly,
      separator,
      justify_bottom,
      justify_top,
      justify_middle,
      align_right,
      align_left,
      align_center,
      normal;

   // ctor. Use new to create a pointer, which the container will look after
   JCnrColumn( JContainer *cnr, long offset, JCnr::column_type,
               const char *title, ulong style = JCnrColumn::normal,
               BOOL titlereadonly = true);
   JCnrColumn( const JCnrColumn &copy);

   // the column title
   JCnrColumn &editTitle();
   JCnrColumn &setTitle( const char *txt);
   JStr        title() const { return JStr( data->title); }

   // set the visibility of the column
   JCnrColumn &show( BOOL show = true);
   JCnrColumn &hide() { return show( false); }

   // getting rid of columns. When free'd, the object dies.
   void remove( BOOL freeit = true);
   void free();

   // return related columns
   JCnrColumn *next() const;
   JCnrColumn *previous() const;

   // set the splitbar to be after this column
   JCnrColumn &setSplitbar();
   // make this column the one that gets 'open' emphasis.
   JCnrColumn &setObjectColumn();

   int operator == (const JCnrColumn &op2) const;
};

// used by the container
typedef JSequence<JCnrColumn *> JCnrColumnList;

#endif
