/*
 * JCnrH.hpp
 *
 * Container window messages (private to Jlib)
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcnrh_h
#define _jcnrh_h

#include "JLib.h"
#include "JHandler.hpp"
#include "JKeyH.hpp"

class JEventData;
class JContainer;
class JKeyEvent;

// this also handles print & discard messages from the os2 shredder & printer
// objects, which are sent if the dragitem supports their respective rm's.
class JCnrHandler : public JHandler
{
 public:
   JCnrHandler() : JHandler() {}
   BOOL handle( JEventData *e);
   BOOL destroy( JContainer *cnr);
   BOOL menuEnd( JContainer *cnr);
   BOOL dropNotify( JContainer *cnr, ulong hwnd, void *info);
};

class JCnrKeyHandler : public JKeyHandler
{
 public:
   JCnrKeyHandler() : JKeyHandler() {}
   BOOL keypress( const JKeyEvent &e);
};

#endif
