/*
 * JCnrODH.hpp
 *
 * Owner-draw handlers & events for the container control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcnrodh_h
#define _jcnrodh_h

#include "JLib.h"
#include "JOwnerDH.hpp"
#include "JPSpace.hpp"

class JContainer;
class JCnrRecord;
class JCnrColumn;

class JBPSpace;

// Event & handler for the paint-background aspect of custom cnrs ------------
class JCnrPaintEvent : public JEvent
{
 public:
   JCnrPaintEvent( JEventData *e) : JEvent( e) {}

   JBPSpace    ps() const;
   JRect       updateRect() const;
   JContainer *cnr();
};

class JCnrPaintHandler : public JHandler
{
 public:
   JCnrPaintHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   // need to setrc to true if you process this
   virtual BOOL paintBackground( JCnrPaintEvent &) { return false; }
};

// Events & handler for custom cnrobjects. This enables you to draw records, -
// details view columns & titles, and container titles. ----------------------
// base draw event, sent when you can draw the cnr title
class JCnrDrawEvent
{
 protected:
   JDrawItemEvent *e;
   JCnrDrawEvent() : e( 0) {}

 public:
   JCnrDrawEvent( JDrawItemEvent &ev) : e( &ev) {}

   JContainer *cnr();
   JBPSpace    ps() const     { return e->ps(); }
   JRect       rect() const   { return e->itemRect(); }

   // usable for setrc and window methods
   JDrawItemEvent *operator -> () const { return e; }
};

// sent when you can draw a record
class JCnrRecordDrawEvent : public virtual JCnrDrawEvent
{
 public:
   JCnrRecordDrawEvent( JDrawItemEvent &e) : JCnrDrawEvent( e) {}

   JCnrRecord *record();
};

// sent when you can draw a column title
class JCnrColumnDrawEvent : public virtual JCnrDrawEvent
{
 public:
   JCnrColumnDrawEvent( JDrawItemEvent &e) : JCnrDrawEvent( e) {}

   JCnrColumn *column() const;
};

// sent when you can draw a column value for a record
class JCnrColRecDrawEvent : public JCnrRecordDrawEvent,
                                    public JCnrColumnDrawEvent
{
 public:
   JCnrColRecDrawEvent( JDrawItemEvent &e) : JCnrRecordDrawEvent( e),
                                             JCnrColumnDrawEvent( e) {}
};

// attach this handler to the cnr's owner window if it's not adopted, or to
// the cnr if it is.
class JCnrObjectPaintHandler : public JOwnerDrawHandler
{
 public:
   JCnrObjectPaintHandler( ulong cnrID) : JOwnerDrawHandler( cnrID) {}
   BOOL drawItem( const JDrawItemEvent &e);

   // return false (the default) to let the cnr draw the thing
   virtual BOOL drawCnrTitle( JCnrDrawEvent &)             { return false; }
   virtual BOOL drawRecordText( JCnrRecordDrawEvent &)     { return false; }
   virtual BOOL drawRecordGraphic( JCnrRecordDrawEvent &)  { return false; }
   // tree view
   virtual BOOL drawTreeIcon( JCnrRecordDrawEvent &)       { return false; }
   // details view
   virtual BOOL drawColumnTitle( JCnrColumnDrawEvent &)    { return false; }
   virtual BOOL drawColumn( JCnrColRecDrawEvent &)         { return false; }
};

#endif
