/*
 * JColour.hpp
 *
 * Miscellaneous things to do with colours in general
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcolour_h
#define _jcolour_h

#include "JLib.h"

struct _RGB2;

class JColour
{
   char bBlue, bGreen, bRed;
   char dummy;

 public:
   JColour( char red, char green, char blue);
   JColour( ulong dword);

   // get the colour dword. MSByte=0.
   ulong asULong() const { return ( bRed * 65536) + ( bGreen * 256) +  bBlue; }

   // cels
   const char &cRed() const     { return bRed; }
   const char &cGreen() const   { return bGreen; }
   const char &cBlue() const    { return bBlue; }
   char &cRed()                 { return bRed; }   
   char &cGreen()               { return bGreen; } 
   char &cBlue()                { return bBlue; }  

   // some handy colours
   static const JColour
      white,
      black,
      blue,
      red,
      pink,
      green,
      cyan,
      yellow,
      pale_grey,
      dark_grey,
      dark_blue,
      dark_red,
      dark_pink,
      dark_green,
      dark_cyan,
      brown;

   // System colour table access
   static JColour system( short ndx);

   static const JColour
      shadowHilightBackground,
      shadowHilightForeground,
      shadowText,
      entryfield,
      menuDisabledText,
      menuHilight,
      menuHilightBackground,
      pageBackground,
      controlBackground,
      lightButton,
      middleButton,
      darkButton,
      defaultButton,
      titlebarBottom,
      shadow,
      iconText,
      dialogBackground,
      hilightForeground,
      hilightBackground,
      inactiveTitleBackground,
      activeTitleBackground,
      inactiveTitleText,
      activeTitleText,
      outputText,
      staticText,
      scrollbar,
      desktopBackground,
      activeTitlebar,
      inactiveTitlebar,
      menuBackground,
      windowBackground,
      windowFrame,
      menuText,
      windowText,
      titleText,
      activeBorder,
      inactiveBorder,
      windowBackground2,
      helpBackground,
      helpText,
      helpHilight;

   // PM compatibility
   operator _RGB2 * () const;
   operator _RGB2 & () const;
};

#endif
