/*
 * JControl.hpp
 *
 * Interface for all GUI controls
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcontrol_h
#define _jcontrol_h

#include "JLib.h"
#include "JWindow.hpp"

class JCtlEvent;
class JHandler;

class JControl : public JWindow
{
 public:
   JControl( JWindow *parent, ushort i);
   JControl( ulong hwnd) : JWindow( hwnd) {}
   JControl()                             {}

   static const unsigned long // coupla styles
      tabstop,
      group;

   virtual BOOL event( const JCtlEvent &e) = 0;
   JWindow &attach( JHandler *h);
};

#endif
