/*
 * JCstLBox.hpp
 *
 * Custom Listbox control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jclbox_h
#define _jclbox_h

#include "JLib.h"
#include "JListBox.hpp"
#include "JCoord.hpp"

class JWindow;
class JBPSpace;

// This scheme doesn't allow for differently-sized items, hmm.
class JCustomLBox : public JListBox
{
   void  setup( JWindow *w);

 protected:
   JSize itemSize;

 public:
   JCustomLBox( JWindow *w, ulong id, const JSize &itemSize);
   JCustomLBox( JWindow *parent, const JPoint &pos, const JSize &size,
                ulong id, const JSize &itemSize,
                ulong style = JListBox::normal);

   // access to drawn sizes
   short itemHeight() const              { return itemSize.y; }
   JCustomLBox &setItemHeight( short y);
   short itemWidth() const               { return itemSize.x; }
   JCustomLBox &setItemWidth( short x);

   // method called when an item needs to be drawn
   virtual void drawItem( JListBox::item &item, const JBPSpace &ps, 
                          JRect &rect, BOOL hilight) = 0;
};

#endif
