/*
 * JCtlH.hpp
 *
 * Control event and handler class definition
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jctlevent_h
#define _jctlevent_h

#include "JLib.h"
#include "JEvent.hpp"
#include "JHandler.hpp"

class JCtlEvent : public JEvent
{
 public:
   JCtlEvent( JEventData *e) : JEvent( e) {}
   // control id
   ushort id() const               { return e->mp1.s1(); }
   // notify code ( eg. BN_CLICKED)
   ushort notify() const           { return e->mp1.s2(); }
   // mp2
   ulong  data() const             { return e->mp2; }
};

// Handler; attach this to parents who have children which generate notifies --
class JCtlHandler : public JHandler
{
   short id; // can handle for id
 public:
   JCtlHandler( short hid = -1) : JHandler(), id( hid) {}
   BOOL handle( JEventData *e);

   virtual BOOL control( const JCtlEvent &) { return false; }
};

#endif
