/*
 * JCusButt.hpp
 *
 * Custom button control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jcbutt_h
#define _jcbutt_h

#include "JLib.h"
#include "JPushBut.hpp"
#include "JCoord.hpp"

class JWindow;
class JCtlEvent;
class JBPSpace;

class JCustomButton : public JPushButton
{
 public:
   JCustomButton( ulong h) : JPushButton( h) {}
   JCustomButton( JWindow *w, ulong id) : JPushButton( w, id) {}
   JCustomButton( JWindow *parent, const JPoint &pos, const JSize &size,
                  ulong id, ulong style = JPushButton::normal);

   enum ptype {
      normal    = 0x400,
      hilighted = 0x100,
      disabled  = 0x200
   };

   // extra event handler for the paint notify thingy
   virtual BOOL event( const JCtlEvent &e);
   virtual BOOL paint( JBPSpace &ps, JRect &wrect, ptype state) = 0;
};

#endif
