/*
 * JDC.hpp
 *
 * Device context classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdc_h
#define _jdc_h

#include "JLib.h"

class JWindow;
class JSize;

class JDeviceContext // pseudo-abc
{
 protected:
   ulong hdc;
   ulong close();

   JDeviceContext() : hdc( 0) {}

 public:
   virtual ~JDeviceContext() { close(); }

   ulong handle() const     { return hdc; }
   operator ulong () const  { return hdc; }

   enum sort {
      unknown,
      plotter,
      display,
      printer,
      camera,
      postscript
   };

   // device type & capabilities
   sort type() const;
   ulong version() const;

   JSize size( BOOL inChars = false) const;

   ulong horzRes() const;
   ulong vertRes() const;

   ulong colours() const;
   ulong colourPlanes() const;
   ulong colourDepth() const;

   ulong horzFontRes() const;
   ulong vertFontRes() const;

   BOOL  supportsTransparency() const;
};

class JReadOnlyDC : public JDeviceContext
{
 public:
   JReadOnlyDC( ulong w);
  ~JReadOnlyDC() { hdc = 0; }
};

class JWindowDC : public JDeviceContext
{
 public:
   JWindowDC( JWindow *w);
  ~JWindowDC() { hdc = 0; }
};

class JMemoryDC : public JDeviceContext
{
 public:
   JMemoryDC();
};

class JMetafileDC : public JDeviceContext
{
 public:
   JMetafileDC();
  ~JMetafileDC()  { close(); }

   // call to extract the metafile handle
   ulong complete() { return close(); }
};

#endif
