/*
 * JDialog.hpp
 *
 * Dialogs loaded from resource libraries
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdialog_h
#define _jdialog_h

#include "JLib.h"
#include "JMother.hpp"
#include "JModule.hpp"

class JResID;

class JDialog : public JMother
{
 public:
   JDialog( JWindow *owner, JResID id,
            JWindow *parent = &JWindow::theDesktopWindow,
            const JModule &md = JModule::theResMod);

   // for owner-less dialogs, like pages of a notebook
   JDialog( JResID id,
            JWindow *parent = &JWindow::theDesktopWindow,
            const JModule &md = JModule::theResMod);

   // modal processing -- functioncall semantics
   ulong showModally( BOOL sysModal = false) const;
   // notional return from the function
   void dismiss( ulong result);

   // when the user presses ESC in a dialog, you'll get a wm_command with
   // the following id.  !! I ought to get round to intercepting this...
   static const ulong idCancel;

   // note change in default from jmother/jframe; generally don't want to
   // end the message loop when a dialog gets closed.
   virtual BOOL closing() { return true; }

   // miscellanea
   JPoint &mapPoint( JPoint &ptDlg);
};

#endif
