/*
 * JDrag.hpp
 *
 * Dragndrop enumerations, static functions, etc.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdrag_h
#define _jdrag_h

#include "JLib.h"
#include "JCoord.hpp"
#include "JStr.hpp"

class JWindow;

class JDrag
{
 public:

   // operation types --------------------------------------------------------
   enum operation {
      def     = 0xbffe,
      move    = 0x0020,
      copy    = 0x0010,
      link    = 0x0018,
      create  = 0x0040,
      weird   = 0xbfff
   };

   // dragitem supported actions ---------------------------------------------
   static const ushort
      copyable,
      moveable,
      linkable,
      createable;

   // drag status types; what's happening now --------------------------------
   enum dtype {
      lazyDrag,
      drag,
      noDrag
   };

   // lazy drag
   static JPoint lazyDrop( JWindow *target, JDrag::operation o);
   static void   cancelLazyDrag();
   static dtype  currentDrag();

   // rendering mechanisms - how to transfer the data ------------------------
   class rm {
      char *mech;
    public:
      rm( const rm &copy);
      rm( char *s);
     ~rm();
      char *value() const;
   };

   static const rm
      file,
      print,
      discard;//,
      //direct,
      //dde;

   // rendering formats - how the data should be interpreted -----------------
   class rf {
      char *fmt;
    public:
      rf( const rf &copy);
      rf( char *s);
     ~rf();
      char *value() const;
   };

   static const rf
      bitmap,
      metafile,
      rtf,
      text,
      unknown;

   // combined rmf class -----------------------------------------------------
   // Eg. a spreadsheet might support rm: file, direct transfer, and rf:
   // spreadsheet, metafile, text.
   // A target application might request the data be put in a file, in text
   // format, which it could then load at the simpler end, or request it as a
   // spreadsheet directly transferred through shared memory.
   // It would do this by checking the source supported this combination of
   // rm & rf, and if it did, filling in the dragtransfer 'required' rmf field
   class rmf {
      char *m;
      char *f;
    public:
      rmf( const rmf &copy);
      rmf( const rm &mech, const rf &format);
     ~rmf();
      rmf &add( const rm &mech);
      rmf &add( const rf &format);
      JStr value() const;
      char *RM() const { return m; }
      char *RF() const { return f; }
   };

   // types - not sure what these are used for. Only seem kinda relavent in --
   // the context of an operation where rm = file.
   class type {
      char *t;
    public:
      type( const type &copy);
      type( char *s);
     ~type();
      char *value() const { return t; }
   };

   static const JDrag::type
      t_text,
      t_binary,
      t_unknown;

   // reply to dm_dragover ---------------------------------------------------
   enum dropState {
      no_location,
      yes,
      no_operation,
      never
   };

   // reply to print/discard rendering queries -------------------------------
   enum psr {
      doneIt = 1,
      youDoIt,
      abort
   };

   // place to hold the current dragndrop info for apps ----------------------
   struct draginfo {
      void  *pDraginfo;
      ulong  cDragitems;
      BOOL   isSource;
      ulong  cLazyDrags;
      draginfo() : pDraginfo( 0), cDragitems( 0), isSource( 0), cLazyDrags( 0) {}
   };
   static draginfo Info;
};

struct JDropOk
{
   JDrag::dropState state;
   JDrag::operation op;
   JDropOk( JDrag::dropState s, JDrag::operation o);
   JDropOk();
};

#endif
