/*
 * JDragH.hpp
 *
 * Source drag handlers
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdragh_h
#define _jdragh_h

#include "JLib.h"
#include "JHandler.hpp"
#include "JEvent.hpp"
#include "JCoord.hpp"
#include "JDrag.hpp"
#include "JDragSet.hpp"
#include "JDrgItem.hpp"

// sent when the user drags the mouse
class JBeginDragEvent : public JEvent
{
   ulong l;

 public:
   JBeginDragEvent( JEventData *e, ulong L) : JEvent( e), l( L) {}
   JPoint pos() const { return JPoint( e->mp1.s1(), e->mp1.s2()); }
   BOOL   isLazy() const { return l; }
};

// sent when the target views the operation as over
class JDragEndEvent : public JEvent
{
   ushort u;

 public:
   JDragEndEvent( JEventData *e, ushort U) : JEvent( e), u( U) {}
   ulong itemID() const { return e->mp1; }
   JDrag::operation op() const { return (JDrag::operation) u; }
   BOOL targetOK() const;
};

// attach this to windows you want to drag from
class JDragHandler : public JHandler
{
   ushort lastOp;

 public:
   JDragHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   // return a new'd jdragitem, or null to decline the event
   virtual JDragItem *beginDrag( const JBeginDragEvent &) { return 0; }
   virtual BOOL dragEnded( const JDragEndEvent &)         { return false; }
};

// handler/event for the dm_discard notifies produced by the system shredder -
class JDiscardEvent : public JEvent
{
   JDragSet set;

 public:
   JDiscardEvent( JEventData *e) : JEvent( e), set( e->mp1()) {}
   JDragSet &dragSet() { return set; }
};

class JDiscardHandler : public JHandler
{
 public:
   JDiscardHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL discard( JDiscardEvent &) { return false; }
};

// handler/event for the print notifies produced by the system printer -------
class JPrintEvent : public JEvent
{
   JDragItem item;
   BOOL      f;
   friend class JPrintHandler;
 public:
   JPrintEvent( JEventData *e) : JEvent( e), item( e->mp1()), f( false) {}
   JDragItem &dragItem() { return item; }
   void     *pPrintDest() { return e->mp2(); }
   // call this if: 1) you return true from JPrinthandler::print
   //               2) you want the system printer to print your document
   void      waiveResponsibility() { f = true; }
};

class JPrintHandler : public JHandler
{
 public:
   JPrintHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL print( JPrintEvent &) { return false; }
};

#endif
