/*
 * JDragSet.hpp
 *
 * Dragndrop operation object
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdragset_h
#define _jdragset_h

#include "JLib.h"
#include "JDrag.hpp"

class JDragPS;
class JWindow;
class JDragItem;

// provides read-only access to a drag operation
class JDragSet
{
 protected:
   ulong flFree;
   void *info;
   JDragSet( BOOL isLazy);

 public:
   // wraps PDRAGINFO given
   JDragSet( void *v, BOOL freeStrs = false);
   // gets current. Throws if there isn't one
   JDragSet();
   // frees various resources as appropriate
   virtual ~JDragSet();

   // access to items being dragged
   ulong items() const;
   JDragItem operator [] ( ulong i);

   // get operation type
   JDrag::operation opType() const;

   // Now, in my book, you ought not to accept a bunch of dragitems unless
   // you can do something - the same thing - to all of them.
   // So we provide several methods to look through all the items - it's all
   // or nothing!
   BOOL willAllow( JDrag::operation);
   BOOL canRenderAs( const JDrag::rmf &r);
   BOOL hasRenderingMech( const JDrag::rm &r);
   BOOL hasRenderingFmt( const JDrag::rf &r);
   BOOL isOfType( const JDrag::type &t);

   // get a ps for the target window during a drag
   JDragPS getPS( JWindow &w) const;

   // send a renderprepare to the source
   BOOL prepare( void *xfer) const;

   // call endconversation for each dragitem
   JDragSet &endConversation( BOOL ok = true);
};


// Base class for dragsets which start a drag
class JVDragSet : public JDragSet
{
 protected:
   ulong current;
   JVDragSet( JWindow *w, ulong c, BOOL lz);

 public:
   virtual ~JVDragSet();

   // set operation
   JVDragSet &setOpType( JDrag::operation);

   // add an item
   virtual JVDragSet &addDragItem( const JDragItem &item);
};


// to instigate a standard drag
class JStdDragSet : public JVDragSet
{
   void  *images;
   ulong  cImages;

 public:
   // wraps current if possible, else creates
   JStdDragSet( JWindow *w, ulong cItems = 1);
  ~JStdDragSet();

   // add an item
   JStdDragSet &addDragItem( const JDragItem &item);

   // start a drag operation
   JWindow *drag();
};


// to instigate a lazy drag
class JLazyDragSet : public JVDragSet
{
 public:
   // wraps current if possible, else creates
   JLazyDragSet( JWindow *w, ulong cItems = 1);
  ~JLazyDragSet();

   // start/continue a drag operation
   JLazyDragSet &lazyDrag();
};

#endif
