/*
 * JDrgItem.hpp
 *
 * Base classes for things wot get dragndrop'd
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdrgitem_h
#define _jdrgitem_h

#include "JLib.h"
#include "JDrag.hpp"
#include "JStr.hpp"

class JWindow;

// this is the base dragitem class. Classes which inherit from this are used.
class JDragItem
{
   void *dragitem;
   void *dragimage;

   friend class JVDragSet;
   friend class JStdDragSet;
   friend class JDragTransfer;
   friend class JSourceRenderEvent;
   friend class JTargetRenderEvent;

   static ulong makeStr( const char *s);
   static JStr  getStr( ulong hStr);
   static void  replaceStr( ulong &hstr, const char *s);

 public:
   JDragItem( const JDrag::rmf &rmf, const JDrag::type &t, ulong hImage,
              const char *cnrName, const char *targetName,
              const char *sourceName, ushort ops, BOOL imageIsBmp = false);
   JDragItem( void *pdragitem);
   virtual ~JDragItem();

   // item id - interpret as desired. Useful place for ref to c++ object...
   JDragItem &setItemID( ulong u);
   ulong      itemID() const;

   // set the window which receives msgs for this item; the default is that
   // which calls JDragSet::drag()
   JDragItem &setItemWindow( JWindow *w);
   ulong      itemWindow() const;

   // called after processing dm_drag for the item, to let the source know
   // everything's fine & over for it.
   JDragItem &endConversation( BOOL happy);

   // various flags (!! more needed)
   // source requires a dm_renderprepare
   JDragItem &needPrepare( BOOL b = true);
   BOOL       needsPrepare() const;
   JDragItem &onRemovableMedia( BOOL b = true);
   BOOL       isOnRemovabelMedia() const;

   // set supported operations for this item.
   // use ..able constants in JDrag.
   JDragItem &setSupportedOps( ushort ops);
   ushort     supportedOps() const;
   BOOL       supports( JDrag::operation);

   // set offset of pointer from icon
   JDragItem &setOffset( long x, long y);

   // access to various string things
   JStr       containerName() const;
   JDragItem &setContainerName( const char *s);
   JStr       targetName() const;
   JDragItem &setTargetName( const char *s);
   JStr       sourceName() const;
   JDragItem &setSourceName( const char *s);

   // supported rm, rf, types...
   BOOL hasType( const JDrag::type &t) const;
   BOOL hasRenderingMF( const JDrag::rmf &rmf) const;
   BOOL hasRenderingMech( const JDrag::rm &rm) const;
   BOOL hasRenderingFmt( const JDrag::rf &rf) const;

   // support for printing & discarding
   JDragItem &supportPrint();
   JDragItem &supportDiscard();
};

// a file item which is rendered entirely by the target; no source involvement
// it uses rm_os2file, and doesn't support print or discard by default.
// the default supported actions are copyable + moveable.
class JFileItem : public JDragItem
{
 public:
   // will use a file icon if left as it is
   JFileItem( const char *fileName, const char *cnrName, ulong hIcon = 0,
              const JDrag::rf &r = JDrag::unknown,
              const JDrag::type &t = JDrag::t_unknown);
  ~JFileItem();
};

// a file item which is 'pushed'; ie. the target will ask you to put it
// somewhere. This means the file doesn't need to exist before the drag starts
// default supported actions are copyable + moveable
class JPushedFileItem : public JDragItem
{
 public:
   // again, uses a standard file icon by default.
   // need to supply a filename for the target.
   JPushedFileItem( const char *fileName, ulong hIcon = 0,
                    const JDrag::rf &r = JDrag::unknown,
                    const JDrag::type &t = JDrag::t_unknown);
  ~JPushedFileItem();
};

// a base item for deriving intra-process drags; generally you'd have one
// rendering for the app, and be able to pass the message based on the type
// of the item and the itemID. The derived class should provide type-safe
// methods to get & set this.
// default supported actions are linkable + copyable + moveable
class JCustomItem : public JDragItem
{
 public:
   JCustomItem( const JDrag::rmf &rmf, ulong itemID, ulong hIcon);
  ~JCustomItem();
};

#endif
