/*
 * JDrgXfer.hpp
 *
 * Dragndrop rendering classes and handlers
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdrgx_h
#define _jdrgx_h

#include "JLib.h"
#include "JStr.hpp"
#include "JDrag.hpp"
#include "JHandler.hpp"
#include "JEvent.hpp"

class JDragItem;

// Create an object of this class to kick off a rendering conversation -------
class JDragTransfer
{
   void *xfer;
 public:
   JDragTransfer( JDragItem &dItem, const JDrag::rmf &rmf,
                  const char *renderTo,
                  JDrag::operation op, JWindow *yourself);

   // set a unique id for the transfer, which is preserved in a renderresult
   JDragTransfer &setID( ulong id);

   // if this method returns true, then the source has begun to render the
   // item; a rendercomplete will be sent you when the operation is complete.
   // If the rc is false, then the source failed; no transfer is possible.
   BOOL requestRender();
};

// Source rendering event ----------------------------------------------------
class JSourceRenderEvent : public JEvent
{
   void *xfer;
   void *info;
   BOOL  m;
   friend class JSourceRenderHandler;

 public:
   JSourceRenderEvent( JEventData *e, BOOL m);
  ~JSourceRenderEvent();

   JStr             renderTo() const;
   JDrag::operation op() const;
   JDragItem        dragItem() const;
   BOOL             verifyRM( const JDrag::rm &rm) const;
   BOOL             verifyRF( const JDrag::rf &rf) const;
};

// Source rendering handler --------------------------------------------------
class JSourceRenderHandler : public JHandler
{
 public:
   JSourceRenderHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   // return true if you can carry out the requested rendering
   virtual BOOL ableToRender( JSourceRenderEvent &)    { return false; }
   // you must override this method if you do the above
   virtual BOOL render( JSourceRenderEvent &)          { return false; }
};

// Target rendering event ----------------------------------------------------
class JTargetRenderEvent : public JEvent
{
   void *xfer;
   void *info;
   BOOL  s;
   friend class JTargetRenderHandler;

 public:
   JTargetRenderEvent( JEventData *e);
  ~JTargetRenderEvent();

   ulong getID() const;
   JStr  renderedTo() const;
   JDragItem dragItem() const;

   // call this method if the rendering operation fails
   void failed() { s = false; }
};

// Target rendering handler --------------------------------------------------
class JTargetRenderHandler : public JHandler
{
 public:
   JTargetRenderHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   // nb DO NOT call the dragitem's endconversation method.
   virtual BOOL renderComplete( JTargetRenderEvent &) { return false; }
};

#endif
