/*
 * JDropH.hpp
 *
 * Target drag (drop) handler
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdroph_h
#define _jdroph_h

#include "JLib.h"
#include "JHandler.hpp"

#include "JCoord.hpp"
#include "JMParam.hpp"
#include "JDrag.hpp"
#include "JDragSet.hpp"
#include "JEvent.hpp"

// base drop class
class JBDropEvent : public JEvent
{
   JDragSet set;

 public:
   JBDropEvent( JEventData *e) : JEvent( e), set( e->mp1()) {}
   JDragSet &dragSet() { return set; }
};

// sent when something is dragged over a window
class JDragOverEvent : public JBDropEvent
{
   JDropOk ok;
   friend class JDropHandler;

 public:
   JDragOverEvent( JEventData *e) : JBDropEvent( e) {}

   JPoint    pos() { return JPoint( e->mp2.s1(), e->mp2.s2()); }

   void setDropState( JDrag::dropState s) { ok.state = s; }
   void setOperation( JDrag::operation o) { ok.op = o; }
};

// sent when a dragset leaves the window
typedef JBDropEvent JDragLeaveEvent;

// sent when the user requests help on drags from you
typedef JBDropEvent JDropHelpEvent;

// sent when stuff gets dropped on you
class JDropEvent : public JBDropEvent
{
   ulong flDelay;
   friend class JDropHandler;

 public:
   JDropEvent( JEventData *e) : JBDropEvent( e), flDelay( 0) {}

   // call this method if you need to have a rendering conversation
   void delayDelete() { flDelay = true; }
};

// attach this handler to windows you want to be able to drop things on
class JDropHandler : public JHandler
{
 public:
   JDropHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL dragOver( JDragOverEvent &)     { return false; }
   virtual BOOL dragLeave( JDragLeaveEvent &)   { return false; }
   // note that you don't need to do any `endConversation' stuff;
   // this is all managed for you.
   virtual BOOL dropHelp( JDropHelpEvent &)     { return false; }
   virtual BOOL drop( JDropEvent &)             { return false; }
};

#endif
