/*
 * JDtTime.hpp
 *
 * Date & time classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jdttime_h
#define _jdttime_h

#include "JLib.h"
#include "JStr.hpp"

struct _CDATE;
struct _FTIME;
struct _CTIME;
struct _FDATE;

class JDate
{
   uchar  d;
   uchar  m;
   ushort y;

 public:
   JDate(); // current date
   JDate( const _CDATE &cDate); // container date structure
   JDate( const _FDATE &fDate); // cp-file date structure

   uchar  &day()               { return d; }
   uchar  &month()             { return m; }
   JStr    monthName() const;
   ushort &year()              { return y; }

   // returns user-format specific nnxnnxnn
   JStr   date() const;

   static JStr today();

   JDate &setCurrentDate();
};

class JTime
{
   uchar h;
   uchar m;
   uchar s;
   uchar dummy;

 public:
   JTime(); // now
   JTime( const _CTIME &cTime); // container time class
   JTime( const _FTIME &fTime); // cp-file time class

   uchar &hours()      { return h; }
   uchar &minutes()    { return m; }
   uchar &seconds()    { return s; }

   // returns user-format specific
   JStr time() const;
   static JStr now();
   JTime &setCurrentTime();
};

class JDateTime : public JTime, public JDate
{
 public:
   JDateTime();
   JDateTime( const _FTIME &fTime, const _FDATE &fDate);
   JDateTime( const _CTIME &cTime, const _CDATE &cDate);

   static JStr dateTime();

   JDateTime &setAsCurrent();
};

#endif
