/*
 * JEntFld.hpp
 *
 * Entry field gui control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jentfld_h
#define _jentfld_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"
#include "JStr.hpp"

class JWindow;
class JCtlEvent;

class JEntryField : public JControl
{
 public:

   // style
   static const unsigned long
      normal,
      autoSize,
      autoScroll,
      autoTab,
      margin,
      readOnly,
      password,
      alignLeft,
      alignRight,
      alignCenter;

   JEntryField( ulong hwnd) : JControl( hwnd) {}
   JEntryField( JWindow *wnd, ulong id) : JControl( wnd, id) {}
   JEntryField( JWindow *parent, const JPoint &pos, const JSize &size,
                ulong id, ulong style = JEntryField::normal,
                const char *text = "" );

   // clipboard support
   JEntryField &clear();
   JEntryField &cut();
   JEntryField &copy();
   JEntryField &paste();

   // selection
   JEntryField &setSelection( short start = 0, short count = -1);
   JStr getSelection() const;

   // scroll to character position
   JEntryField &scrollTo( short offset);

   // maximum field length - note this defaults to something daft (32?)
   JEntryField &setMaxLength( short count);

   // changed indicator
   BOOL hasChanged() const;

   // readonly field
   JEntryField &setReadonly( BOOL set);
   BOOL isReadonly() const;

   // set insertion mode
   JEntryField &setInsert( BOOL set);

   // event handling
   BOOL event( const JCtlEvent &e);
   virtual BOOL changed()      { return false; }
   virtual BOOL lostFocus()    { return false; }
   virtual BOOL gainedFocus()  { return false; }
   virtual BOOL scrolled()     { return false; }
};

#endif
