/*
 * JEvSem.hpp
 *
 * Event semaphore class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jevsem_h
#define _jevsem_h

#include "JLib.h"

/*
 * A [RE]SET event sem blocks. A POSTED event sem lets waiting threads run
 *
 */

// !! want to add one-shot & auto features

class JEventSem;

class JTimer
{
   ulong hTimer;

 public:
   JTimer( ulong h) : hTimer( h) {}
   void stop() const;
};

class JEventSem
{
   ulong hSem;

 public:
   // opens if possible, else creates
   JEventSem( const char *name, BOOL isPosted = false);
   JEventSem( BOOL shared = false, BOOL isPosted = false);
  ~JEventSem();

   BOOL       post() const; // return true if it was already posted
   ulong      reset() const;

   JEventSem &open(); // open from another process

   JEventSem &wait( ulong time = (ulong)-1);

   ulong      handle() const { return hSem; }

   ulong      postCount() const;

   JTimer     postAfter( ulong milliseconds);
   JTimer     postEvery( ulong milliseconds);
};

#endif
