/*
 * JEvent.hpp
 *
 * EventData & Event class interfaces
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jevent_h
#define _jevent_h

#include "JLib.h"
#include "JMParam.hpp"

class JWindow;

struct JEventData
{
   JWindow *win;
   ulong    msg;
   JMP      mp1;
   JMP      mp2;

   JMR      rc;

   JEventData( JWindow *w, ulong msg, JMP mp1, JMP mp2);
};

class JEvent
{
 protected:
   JEventData *e;
   BOOL        del;

 public:
   JEvent( JEventData *ev) : e( ev) {}
   virtual ~JEvent()                {}
   void setrc( JMR m) const         { e->rc = m; }
   JWindow *window() const          { return e->win; }
   JEventData *data() const         { return e; }
};

inline JEventData::JEventData( JWindow *w, ulong m, JMP p1, JMP p2)
                  : win( w), msg( m), mp1( p1), mp2( p2) {}

#endif
