/*
 * JFile.hpp
 *
 * Usable disk file classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jfile_h
#define _jfile_h

#include "JLib.h"
#include "JStream.hpp"
#include "JBFile.hpp"

class JRFile : public JRStream, public JFile
{
 public:
   JRFile( const char *name, JStream::sharing = JStream::denyNone);
};

class JWFile : public JWStream, public JFile
{
 public:
   JWFile( const char *name, BOOL append = false,
           JStream::sharing = JStream::denyNone);
};

class JRWFile : public JRStream, public JWStream, public JFile
{
 public:
   JRWFile( const char *name, JStream::sharing = JStream::denyNone);
};

// this provides a temporary file object; when it goes out of scope, the
// file is erased, unless it's been `forget()'
class JTempFile : public JRWFile
{
 public:
   JTempFile();
  ~JTempFile();
};

#endif
