/*
 * JFind.hpp
 *
 * File-finder classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jfind_h
#define _jfind_h

#include "JLib.h"
#include "JStr.hpp"
#include "JSet.hpp"

// this is a cursor, if you like, which walks a directory as you instruct
// it. There's also a static function which gets all matches at once into a
// list.

// There's a lot more that could be done here, most notably to do with eas;
// I think however that we'll wait until there's a complete JEA set...

class JFind
{
   JStr  file, curr;
   ulong hDir, spec;

 public:

   enum findspec { // !! don't think this is really complete enough
      normal   = 0x0000,
      all      = 0x0037,
      subdirs  = 0x1000,
      allFiles = 0x0027
   };

   JFind( const char *filespec, JFind::findspec filetype = JFind::normal);
  ~JFind();

   JFind &toFirst();
   JFind &toNext();
   BOOL   isValid() const;

   JStr current() const;

   static void files( const char *filespec, JSet<JStr> &list,
                      JFind::findspec filetype = JFind::normal);
};

#endif
