/*
 * JFocusH.hpp
 *
 * Focus change message handler & event classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jfocush_h
#define _jfocush_h

#include "JLib.h"
#include "JHandler.hpp"
#include "JEvent.hpp"

class JWindow;

// Dispatched when window focus changes occur
class JFocusChangeEvent : public JEvent
{
   JWindow *oter;

 public:
   JFocusChangeEvent( JEventData *e);

   // the window which is gaining what you're losing, or losing what you're
   // gaining. May be null.
   JWindow *other() const { return oter; }
};

// This provides handling for changes in focus, activation (?difference)
// and selection. If you're unsure which to use, the activated/deactivated
// pair are usually the best.
class JFocusChangeHandler : public JHandler
{
 public:
   JFocusChangeHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL lostFocus( const JFocusChangeEvent &)     { return false; }
   virtual BOOL gainedFocus( const JFocusChangeEvent &)   { return false; }

   virtual BOOL activated( const JFocusChangeEvent &)     { return false; }
   virtual BOOL deactivated( const JFocusChangeEvent &)   { return false; }

   virtual BOOL selected( const JEvent &)                 { return false; }
   virtual BOOL deselected( const JEvent &)               { return false; }
};

#endif
