/*
 * JFont.hpp
 *
 * Fonts
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jfont_h
#define _jfont_h

#include "JLib.h"
#include "JStr.hpp"
#include "JExcept.hpp"
#include "JSeq.hpp"
#include "JPtr.hpp"

class JBPSpace;
class JWindow;
class JFile;

struct _FONTMETRICS;
class JFontData;

struct JFontNotFound : public JException
{
   JFontNotFound();
};

class JFont
{
   JFontData *fd;

 public:

   enum wt {
      ultraLight = 1,
      extraLight,
      light,
      semiLight,
      medium,
      semiDark,
      dark,
      extraDark,
      ultraDark
   };

   enum wd {
      ultraCondensed = 1,
      extraCondensed,
      condensed,
      semiCondensed,
      normal,
      semiExpanded,
      expanded,
      extraExpanded,
      ultraExpanded
   };

   JFont( _FONTMETRICS *metrics);

   // probably an outline font; exception thrown if not found
   JFont( const char *name, JBPSpace *ps = 0);
   // for an image font; font returned will be no larger than requested
   JFont( const char *facename, long ptSize, JBPSpace *ps = 0);
   JFont( const JFont &copy);

   virtual ~JFont();

   JStr  face() const;
   JStr  family() const;
   short pointSize() const;
   long  externalLeading() const;
   long  avgeCharWidth() const;
   wt    weight() const;
   wd    width() const;

   // font type - outline or image
   BOOL outline() const;

   // extra attributes
   BOOL italic() const;
   BOOL underlined() const;
   BOOL inverse() const;
   BOOL hollow() const;
   BOOL strikeout() const;
   BOOL bold() const;

   // creates a list of valid fonts. Default is for the screen.
   static JSequence<JFont> &list( JSequence<JFont> &lst, JBPSpace *ps = 0);

   static void addFonts( const JFile &f);

   // opens a modal font dialog centered over the owner
   static JFont pickFont( JWindow *owner, const char *title = 0,
                          JFont *current = 0);

   int operator == ( const JFont &f) const
   { return face() == f.face(); }

   JFont &operator = ( const JFont &arg2);

   // pm things
   JBuffer fattrs() const;
   _FONTMETRICS *fontMetrics();
};

typedef JSequence<JFont> JFontList;

#endif
