/*
 * JFrame.hpp
 *
 * Frame window interface
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jframe_h
#define _jframe_h

#include "JLib.h"
#include "JWindow.hpp"
#include "JMother.hpp"
#include "JCoord.hpp"

class JFrameData;
class JFrameCtl;

class JFrame : public JMother
{
   JFrameData  *data;
   friend class JFrameCtlHandler;

 public:
   static const unsigned long
      normal,
      titleBar,
      sysMenu,
      minButton,
      maxButton,
      hideButton,
      noByteAlign,
      noMoveWithOwner,
      sysModal,
      screenAlign,
      mouseAlign;

   JFrame( char    *title      = "",
           ulong    frameFlags = JFrame::normal,
           ulong    frameStyle = JWindow::normal,
           JWindow &parent     = JWindow::theDesktopWindow );

  ~JFrame();

   // client fiddling
   JWindow *client() const;
   JFrame  &setClient( JWindow *w);
   JFrame  &setMaxClientSize( const JSize &sz);

   // frame extensions
   JFrame &addFrameExtension( JFrameCtl *ctl);
   JFrame &showFrameExtension( ulong id, BOOL show = true);
   JFrame &hideFrameExtension( ulong id)
           { return showFrameExtension( id, 0); }
   JFrame &removeFrameExtension( ulong id);
   // call when you alter the size of a frame control
   JFrame &updateFrameExtensions();

   // ids of frame controls
   JWindow *childWithID( ushort id);

   static const ulong
      idClient,
      idTitlebar,
      idSysmenu,
      idMinMax,
      idMenu;
};

#endif
