/*
 * JFrmeCtl.hpp
 *
 * Abstract frame control class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jframectl_h
#define _jframectl_h

#include "JLib.h"
#include "JWindow.hpp"

class JFrame;
class JSWPArray;
class JRect;
class JSWP;

// Derive from here to add a frame control. In the constructor, initialise
// ctl.
// In the format method, fill in your swp; the adjustclientrect method gets
// called just afterwards, so don't alter the client swp in format.
//
// If you don't need to do anything fancy, like calculate your vertical size
// from the current horizontal size, the default implementations for _format_
// and _adjustClientRect_ will do the right thing for you, inserting the
// control below or above the client area depending on the flag you pass on
// construction.
//
// Left & Right should be easy enough to implement.
class JFrameCtl
{
   BOOL visible; 

 public:

   enum position {
      aboveClient,
      belowClient
   };

 protected:
   ulong    id;
   JWindow *ctl;
   position pos;

   JFrameCtl( ulong Id, position p = aboveClient)
            : visible( true), id( Id), ctl( 0), pos( p) {}
 public:

   virtual ~JFrameCtl() { delete ctl; } // hmm.

   ulong    getID() const { return id; }
   virtual JWindow *window() const { return ctl; }

   virtual void format( JSWPArray &swps, JSWP &swp, JFrame *frame);
   virtual void adjustClientRect( JRect *cli) const;

   // don't call these methods here, use similar ones from class JFrame
   void setVisible( BOOL vis) { visible = vis; }
   BOOL isVisible() { return visible; }

   int operator == ( const JFrameCtl &c) { return id == c.getID(); }
};

#endif
