/*
 * JGButton.hpp
 *
 * Graphical pushbutton control; uses the WC_GRAPHICBUTTON window class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jgbutt_h
#define _jgbutt_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"
#include "JModule.hpp"
#include "JSeq.hpp"

class JGButton : public JControl
{
 public:

   // primary style; pm examples mix animation & twostate, but the docs
   // say this combination is unpredicatable.  It's definitely odd...
   static const ulong
      pushbutton,
      twostate,
      autoTwostate,   // toggles state on presses
      animated,
      autoAnimated,   // starts/stops animation on presses
      mini;           // small button

   enum textStyle {
      flat,
      recessed,
      embossed
   };
 
   JGButton( ulong hwnd) : JControl( hwnd) {}
   JGButton( JWindow *p, ulong id) : JControl( p, id) {}
   JGButton( JWindow *parent, const JPoint &pos, const JSize &size,
             ulong id, const char *text = "", ulong style = pushbutton,
             textStyle t = flat);
 
   // the way this works is you supply a collection of resource ids for
   // bitmaps and the resource module in which they live.
   // Then tell the control which bitmaps to use for what purpose using their
   // 0-based index in that collection.  Easy.
   JGButton &setBitmaps( ushort *usIDs, ulong cIDs,
                         const JModule &mod = JModule::theResMod);
   JGButton &setBitmaps( JSequence<ushort> &ids,
                         const JModule &mod = JModule::theResMod);
 
   // button states
   enum buttonState {
      up = 1,
      down,
      disable,
      hilight,

      beginAnimation = 12,
      endAnimation
   };

   JGButton &setBitmap( buttonState which, ulong index);

   // animation control
   JGButton &startAnimation( BOOL startFromCurrent = false);
   JGButton &stopAnimation();
   BOOL      isAnimating() const;
   // delays between frames measured in ms
   ulong     getFrameDelay() const;
   JGButton &setFrameDelay( ulong ms);
 
   // text position
   textStyle getTextPos() const;
   JGButton &setTextPos( textStyle ts);

   buttonState getCurrentState() const;
   JGButton   &setCurrentState( buttonState b); // (not xxAnimation)

   // event handling
   BOOL event( const JCtlEvent &e);

   virtual BOOL buttonUp()        { return false; }
   virtual BOOL buttonDown()      { return false; }
   virtual BOOL buttonHilighted() { return false; }
   virtual BOOL lostFocus()       { return false; }
   virtual BOOL gainedFocus()     { return false; }
};

#endif
