/*
 * JGLPrim.hpp
 *
 * 'Logical' graphics primitives - settings objects
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jglprim_h
#define _jglprim_h

#include "JLib.h"
#include "JCoord.hpp"
#define NO_PRIMS
#include "JGPrim.hpp"
#undef NO_PRIMS
#include "JFont.hpp"
#include "JGfx.hpp"

class JBitmap;
class JBPSpace;
class JColour;

// use to set the colour & mix for the ps in general -------------------------
// Defaults to normal, black on white
class JBundle;
class JGSettings : public JGObject
{
   friend class JBPSpace;

   virtual JBundle *bundle() const;

 protected:
   JBundle *baseB;
   ulong    gstats;

 public:
   JGSettings();
   virtual ~JGSettings();

   JGSettings &setFGMix( JGfx::fgMix::type t);
   JGfx::fgMix::type fgMix() const;

   JGSettings &setBGMix( JGfx::bgMix::type t);
   JGfx::bgMix::type bgMix() const;

   JGSettings &setFGColour( const JColour &c);
   JColour fgColour() const;

   JGSettings &setBGColour( const JColour &c);
   JColour bgColour() const;

   virtual JGSettings &makeDefaultsFor( JBPSpace &p);
   virtual BOOL        renderIn( JBPSpace &p) const;
};

// Lines - line and arc primitives -------------------------------------------
class JLineBundle;
class JLineSettings : public JGSettings
{
   JLineBundle *b;
   JBundle *bundle() const;

 public:
   JLineSettings();
   JLineSettings( void *v, ulong m);
  ~JLineSettings();

   JLineSettings &setEnds( JGfx::line::end::type e);
   JGfx::line::end::type ends() const;

   JLineSettings &setJoin( JGfx::line::join::type j);
   JGfx::line::join::type join() const;

   JLineSettings &setType( JGfx::line::type::typ t);
   JGfx::line::type::typ type() const;

   JLineSettings &setLook( JGfx::line::width::type w);
   JGfx::line::width::type look() const;

   JLineSettings &setWidth( long l);
   long width() const;

   JLineSettings &makeDefaultsFor( JBPSpace &p);
   BOOL           renderIn( JBPSpace &p) const;
};

// Images - image primitives -------------------------------------------------
class JImageSettings : public JGSettings
{
 public:
   JImageSettings();
   JImageSettings( void *v, ulong l);

   JImageSettings &makeDefaultsFor( JBPSpace &p);
   BOOL            renderIn( JBPSpace &p) const;
};

// Markers - constants valid for default set ---------------------------------
class JMarkerBundle;
class JMarkerSettings : public JGSettings
{
   JMarkerBundle *b;
   JBundle       *bundle() const;

   JFont f;

 public:
   JMarkerSettings();
   JMarkerSettings( void *v, ulong l);
  ~JMarkerSettings();

   JMarkerSettings &setSymbol( JGfx::marker::sym s);
   JGfx::marker::sym symbol() const;

   JMarkerSettings &setSize( const JSize &s);
   JSize size() const;

   JMarkerSettings &setFont( const JFont &f);

   JMarkerSettings &makeDefaultsFor( JBPSpace &p);
   BOOL             renderIn( JBPSpace &p) const;
};

// Areas - how a thing is filled ---------------------------------------------
class JFillBundle;
class JFillSettings : public JGSettings
{
   JFillBundle *b;
   JBundle     *bundle() const;

   ulong hb;

 public:
   JFillSettings();
   JFillSettings( void *v, ulong l);

   JFillSettings &setPattern( JGfx::pattern::sym t);
   JFillSettings &setPattern( const JBitmap &b);
   JGfx::pattern::sym pattern() const;

   JFillSettings &setPatternOrigin( const JPoint &p);
   JPoint patternOrigin() const;

   JFillSettings &makeDefaultsFor( JBPSpace &p);
   BOOL           renderIn( JBPSpace &p) const;
};

// Text ----------------------------------------------------------------------
class JTextBundle;
class JTextSettings : public JGSettings
{
   JTextBundle *b;
   JBundle *bundle() const;

   JFont f;

 public:
   JTextSettings();
   JTextSettings( void *v, ulong m);

   JTextSettings &setGradient( const JPoint &g);
   JPoint gradient() const;

   JTextSettings &setShear( const JPoint &vertical);
   JPoint shear() const;

   JTextSettings &setFont( const JFont &f);

   JTextSettings &setSize( const JSize &s);
   JSize size() const;

   JTextSettings &makeDefaultsFor( JBPSpace &p);
   BOOL           renderIn( JBPSpace &p) const;
};

// Arc parameters ------------------------------------------------------------
class JArcSettings : public JGObject
{
   long p, q, r, s;

 public:
   JArcSettings();
   JArcSettings( void *v);

   JArcSettings &setMajorPoint( const JPoint &p);
   JArcSettings &setMajorPoint( long x, long y);
   JPoint majorPoint() const;

   JArcSettings &setMinorPoint( const JPoint &p);
   JArcSettings &setMinorPoint( long x, long y);
   JPoint minorPoint() const;

   JArcSettings &makeDefaultsFor( JBPSpace &p);
   BOOL          renderIn( JBPSpace &p) const;
};

#endif
